/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyByte
implements IProperty<Byte> {
    final DirectStorage<Byte> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyByte(DirectStorage<Byte> value) {
        this.value = value;
    }

    public PropertyByte() {
        this(DirectStorage.allocate((byte)0));
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }

    @Override
    public Byte set(Byte value) {
        Byte pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte((int)this.value.get().byteValue());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readByte());
    }

    @Override
    public Byte get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

